
#include <windows.h>
#include "HookSetup.h"
#include "Resource.h"
#define MsgBox(msg) MessageBox(NULL, msg, "HookDemo", MB_OK)

bool gbWin2k = true;	// IsWin2k()

BOOL CALLBACK MainDlgProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);
bool gbRealExit = false;

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	static const UINT WM_CHECK_ITS_ME = RegisterWindowMessage("HookDemo");
	HANDLE hMutexOneInstance = CreateMutex( NULL, FALSE, "HookDemo");
	bool AlreadyRunning = ( GetLastError() == ERROR_ALREADY_EXISTS || GetLastError() == ERROR_ACCESS_DENIED);
	if ( AlreadyRunning )
	{
		MsgBox("HookDemo.exe already run.");
		return 1;
	}
	if(InitAPIHook() <0)
	{
		MsgBox("InitAPIHook error!");
		return 0;
	}

	if(HookAllProcesses() <0)
	{
		MsgBox("Hook Processes error!");

		return 0;
	}
/*	// HookAllProcesses2  
	if(HookAllProcesses2(1000) <0)
	{
		MsgBox("Hook Processes error!");
		return 0;
	}*/
	DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, MainDlgProc);

	UnhookAllProcesses();

	return 0;
}


BOOL CALLBACK MainDlgProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK:
			gbRealExit = true;
			EndDialog(hDlg, IDOK);
			break;
		case ID_HIDE:
			ShowWindow(hDlg, SW_HIDE);
			break;
		}
	case WM_CLOSE:
/*		if(!gbRealExit)
		{
			TCHAR szCmd[MAX_PATH];
			if(GetModuleFileName(NULL,szCmd,MAX_PATH))
			{
				gbRealExit = true;
				WinExec(szCmd,SW_SHOW);
			}
		}*/
		EndDialog(hDlg,IDOK);
	default:
		break;
	}

	return FALSE;
}
